/* IBM_PROLOG_BEGIN_TAG                                                   */
/* This is an automatically generated prolog.                             */
/*                                                                        */
/*                                                                        */
/*                                                                        */
/* Licensed Materials - Property of IBM                                   */
/*                                                                        */
/* (C) COPYRIGHT International Business Machines Corp. 1998,2004          */
/* All Rights Reserved                                                    */
/*                                                                        */
/* US Government Users Restricted Rights - Use, duplication or            */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.      */
/*                                                                        */
/* IBM_PROLOG_END_TAG                                                     */

static char *sccsid = "@(#)48   1.3   src/rsct/pgs/samples/Sample_Node.C, gssamples, rsct_rzauh, rzauh0431a 5/14/01 09:43:26";

#if !defined(_HAGSD_COPYRIGHT_H)
#define _HAGSD_COPYRIGHT_H
static char copyright[] = "Licensed Materials - Property of IBM\n\
(C) COPYRIGHT International Business Machines Corp. 1998,2001.\n\
All Rights Reserved.\n\
US Government Users Restricted Rights - Use, duplication or \n\
disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n";
#endif


/*********************************************************************/
/*
 * Name:  Sample_Node.C
 *
 * Build the sorted list of providers in the system, sorted by node
 * number.
 *
 * See Sample_Subscribe.C for more info.
 */
 /*********************************************************************/

#include "Sample_Node.h"                // Our definitions.

/*********************************************************************/
/*
 * Similar to raw print, "inst/node " layout.  Input value is the number
 * of characters already on line, return number of characters on line if
 * partial line, or zero if not.
 */
/*********************************************************************/

int     Node::PrintSimple(int _num)
{
    int         _outNum, _pLen;

    if (0 == count) return(_num);

    _outNum = _num;

    for (int i = 0; i < count; i++) {
        _pLen = PrintLength(instances[i], myNodeNumber);

        if (80 < (_pLen + _outNum)) {
            cout << endl;
            _outNum = 0;
        }
        cout << instances[i] << "/" << myNodeNumber << " ";
        _outNum += _pLen;
    }

    return(_outNum);
}

/*********************************************************************/
/*
 * Fancy tabular print.
 *
 * Input: index of provider currently printing
 *        number of spaces allowed
 * Output: number of spaces used
 */
/*********************************************************************/

int     Node::PrintFancy(int _index,
                         int _space)
{
    int         _outNum, _pLen;

    // Do we have any more providers?  If not, fill in our slot with blanks.
    if ((_index + 1) > count) {
        for (_pLen = 0; _pLen < _space; _pLen++) {
            cout << " ";
        }
        return(_pLen);
    }

    _pLen = DisplayLen(instances[_index]); // Next instance number to print.

    if (_space <= _pLen) {
        // Just print, it will fill slot.
        cout << instances[_index];
    } else {
        for (_outNum = (_space - _pLen); _outNum > 0; _outNum--) {
            cout << " ";
        }
        cout << instances[_index];
    }

    return(_pLen);
}

/*********************************************************************/
/*
 * Print out the special IP address information, if given.  Receive the
 * of characters already on line, return number of characters on line if
 * partial line, or zero if not (i.e., pack to an 80 col line as above.)
 */
/*********************************************************************/

int     Node::PrintSpecialIP(int _num)
{
    int         _outNum, _pLen;
    char       *_IPprint;

    if (!haveAliases) return(_num);

    _outNum = _num;

    for (int i = 0; i < count; i++) {
        _IPprint = inet_ntoa(*(struct in_addr *)&IPaddress[i]);
        _pLen = strlen(_IPprint);
        if (80 < (_outNum + _pLen)) {
            cout << endl;
            _outNum = 0;
        }
        cout << _IPprint << " ";

        _outNum += _pLen;
    }

    return(_outNum);
}
/*********************************************************************/
/*
 * Print out the special adapter death information, if given.  Receive the
 * of characters already on line, return number of characters on line if
 * partial line, or zero if not (i.e., pack to an 80 col line as above.)
 */
/*********************************************************************/

int     Node::PrintSpecialDeath(int _num)
{
    int         _outNum, _pLen;

    if (!haveDeath) return(_num);

    _outNum = _num;

    for (int i = 0; i < count; i++) {
        if (80 < _outNum) {
            cout << endl;
            _outNum = 0;
        }
        if (HA_GS_ADAPTER_DEAD == deathArray[i]) {
            cout << "Dead ";
            _outNum += 5;
        } else if (HA_GS_ADAPTER_REMOVED == deathArray[i]) {
            cout << "Removed ";
            _outNum += 8;
        } else {
            cout << "Unknown ";
            _outNum += 8;
        }
    }

    return(_outNum);
}
